#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include "Infopage.h"
#include "Encoding.h"
#include "DriverSettings1.h"
#include "DriverSettings2.h"
#include "PrintDemo.h"
#include "UtilsPage.h"

/////////////////////////////////////////////////////////////////////////////

// CPrinterSettings dialog

class CPrinterSettings : public CPropertyPage
{
	DECLARE_DYNAMIC(CPrinterSettings)

public:
	CPrinterSettings();
	virtual ~CPrinterSettings();
	virtual BOOL OnInitDialog();

	HINSTANCE hLib;

// Dialog Data
	enum { IDD = IDD_PRINTERPAGE };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
	afx_msg void OnBnClickedBtnOpenSession();
	afx_msg void OnBnClickedBtnCloseSession();
	afx_msg void OnBnClickedBtnConnectionType();
	afx_msg void OnBnClickedBtnMoveCard();
	afx_msg void OnBtnClickedEjectCard();
	afx_msg void OnBnClickedBtnFlipCard();
	afx_msg void OnBnClickedBtnPrintTestCard();
	afx_msg void OnBnClickedBtnCleanPrinter();
	afx_msg void OnBnClickedBtnRestartPrinter();
	afx_msg void OnBnClickedBtnErrorResponse();
	afx_msg void OnBnClickedBtnEjectMode();
	afx_msg void OnBnClickedGetActionRadio();
	afx_msg void OnBnClickedSetActionRadio();
	afx_msg void OnBnClickedBtnIPSettings();
	afx_msg void OnBnClickedBtnGeneralMsgClr();

private:
	CMainSheet *Parent;

	CInfoPage        *InfoPage;
	CEncoding        *EncodingPage;
	CDriverSettings1 *DriverPage1;
	CDriverSettings2 *DriverPage2;
	CPrintDemo       *PrintPage;
	CUtilsPage       *UtilsPage;

	int PrinterAction;

	CEdit GeneralMsg;
	CComboBox MoveCardCombo;
	CComboBox EjectModeCombo;
	CComboBox ErrorRespCombo;
	CButton OpenSessionBtn;
	CComboBox OpenSessionCombo;
	CButton CloseSessionBtn;
	CButton MoveCardBtn;
	CButton TestCardBtn;
	CButton CleanBtn;
	CButton RestartBtn;
	CButton ErrorRespBtn;
	CEdit GeneralMessage;
	CButton EjectModeBtn;
	CComboBox IPModeCombo;
	CIPAddressCtrl IPAddress;
	CIPAddressCtrl IPSubnet;
	CIPAddressCtrl IPGateway;
	CButton IPSettingsBtn;
	CButton PrinterGet;
	CButton PrinterSet;

	void ControlTabs(BOOL bControl);
	void AddGeneralMessage(CString pMessage);
	void EnableGetSetControls(BOOL bControl);
	void EnableControls(BOOL bControl);
	BYTE SDKBits();
	BOOL PrinterConnected();




	void EjectModeToMsgBox(ID_EJECTMODE EjectMode, ID_READWRITE Action);
	void SetEjectModeBox(ID_EJECTMODE EjectMode);
	ID_RETURN GetEjectMode(PID_EJECTMODE EjectMode);

	void IPSettingsToCtrl(PIPDATA pIPData);
	void IPSettingsToMsgBox(PIPDATA pIPData, ID_READWRITE Action);
	ID_RETURN GetIPSettings(PIPDATA pIPData);

	BOOL ActionIsGet();
};
